﻿using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.EventSystems;
using UnityEngine.UI;

//PageNavigator is a script responsible for handling navigations between pages
public class PageNavigator : MonoBehaviour
{
    public bool BackNavigate;   //A flag to indicate whether the navigation should be backwards
    public PageDefinition NextPage; //The page to navigate forward to
    public bool ClearHistoryOnNavigate; //A flag to indicate whether the navigation history (page stack) should be cleared on navigation

    /// <summary>
    /// Performs the appropriate navigation, either back or forward
    /// </summary>
    public void Navigate()
    {
        if (!BackNavigate && NextPage != null)
        {
            //We're not navigating back and have a next page to go to - navigate there and clear the history as appropriate
            PageManager.NavigateForward(NextPage);

            if (ClearHistoryOnNavigate)
            {
                PageManager.ClearNavigationHistory();
            }
        }

        else if (BackNavigate)
        {
            //We're navigating back - clear the history as appropriate
            PageManager.NavigateBack();

            if (ClearHistoryOnNavigate)
            {
                PageManager.ClearNavigationHistory();
            }
        }
    }
}
